#pragma once

#include <iostream>
#include <sstream>
#include <string>
#include <fstream>

namespace std
{
#ifdef UNICODE
#define tcout wcout 
	typedef wstring tstring;
	typedef wstringstream tstringstream;
	typedef wofstream tofstream;
	typedef wifstream tifstream;
#else
#define tcout cout 
	typedef string tstring;
	typedef stringstream tstringstream;
	typedef ofstream tofstream;
	typedef ifstream tifstream;
#endif
}

#ifndef ZZLAB_APP_NAME
#define ZZLAB_APP_NAME "ZzLab"
#endif

extern void (*ZZLAB_TRACE)(LPCTSTR msg);
extern void (*ZZLAB_LOG)(LPCTSTR msg);
extern void (*ZZLAB_ERROR)(LPCTSTR msg);

#ifdef ZZLAB_ENABLE_TRACE
#define _TRACE(x) { std::tstringstream ss; ss << _T("[") << _T(ZZLAB_APP_NAME) << _T("] ") << x; ZZLAB_TRACE(ss.str().c_str()); }
#else
#define _TRACE(x) {}
#endif

#ifdef ZZLAB_ENABLE_LOG
#define _LOG(x) { std::tstringstream ss; ss << _T("[") << _T(ZZLAB_APP_NAME) << _T("] ") << x; ZZLAB_LOG(ss.str().c_str()); }
#else
#define _LOG(x) {}
#endif

#ifdef ZZLAB_ENABLE_ERROR
#define _ERROR(x) { std::tstringstream ss; ss << _T("[") << _T(ZZLAB_APP_NAME) << _T("][ERROR]: ") << x; ZZLAB_ERROR(ss.str().c_str()); }
#else
#define _ERROR(x) {}
#endif

#define _TRACE_FUNC() _TRACE(_T(__FILE__) << '(' << __LINE__ << _T("): [") << _T(__FUNCTION__) << ']' << std::endl)
#define _TRACE_THIS() _TRACE(_T(__FILE__) << '(' << __LINE__ << _T("): [") << _T(__FUNCTION__) << _T("], 0x") << std::hex << this << std::endl)

#define _TRACE_FUNC0(x) _TRACE(_T(__FILE__) << '(' << __LINE__ << _T("): [") << _T(__FUNCTION__) << _T("] ") << x << std::endl)
#define _TRACE_THIS0(x) _TRACE(_T(__FILE__) << '(' << __LINE__ << _T("): [") << _T(__FUNCTION__) << _T("], 0x") << std::hex << this << std::dec << ' ' << x << std::endl)

#define _LOG_FUNC() _LOG(_T(__FILE__) << '(' << __LINE__ << _T("): [") << _T(__FUNCTION__) << ']' << std::endl)
#define _LOG_THIS() _LOG(_T(__FILE__) << '(' << __LINE__ << _T("): [") << _T(__FUNCTION__) << _T("], 0x") << std::hex << this << std::endl)

#define _LOG_FUNC0(x) _LOG(_T(__FILE__) << '(' << __LINE__ << _T("): [") << _T(__FUNCTION__) << _T("] ") << x << std::endl)
#define _LOG_THIS0(x) _LOG(_T(__FILE__) << '(' << __LINE__ << _T("): [") << _T(__FUNCTION__) << _T("], 0x") << std::hex << this << std::dec << ' ' << x << std::endl)

#define _ERROR_FUNC() _ERROR(_T(__FILE__) << '(' << __LINE__ << _T("): [") << _T(__FUNCTION__) << ']' << std::endl)
#define _ERROR_THIS() _ERROR(_T(__FILE__) << '(' << __LINE__ << _T("): [") << _T(__FUNCTION__) << _T("], 0x") << std::hex << this << std::endl)

#define _ERROR_FUNC0(x) _ERROR(_T(__FILE__) << '(' << __LINE__ << _T("): [") << _T(__FUNCTION__) << _T("] ") << x << std::endl)
#define _ERROR_THIS0(x) _ERROR(_T(__FILE__) << '(' << __LINE__ << _T("): [") << _T(__FUNCTION__) << _T("], 0x") << std::hex << this << std::dec << ' ' << x << std::endl)

#include <comdef.h>

#define HR(x) _HR(x, _T(__FILE__), __LINE__)

inline void _HR(HRESULT x, const TCHAR* file, int line)
{
	if(FAILED(x)) 
	{
		_ERROR(file << '(' << line << _T("): COM error, hr=") << x << std::endl);
		_com_issue_error(x);
	}
}